/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.net.PlainDatagramSocketImpl;
import gnu.java.nio.NIODatagramSocket;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.spi.SelectorProvider;

public final class DatagramChannelImpl
extends DatagramChannel {
    private NIODatagramSocket socket = new NIODatagramSocket(new PlainDatagramSocketImpl(), this);
    private boolean inChannelOperation;

    public final boolean isInChannelOperation() {
        return this.inChannelOperation;
    }

    public final void setInChannelOperation(boolean b) {
        this.inChannelOperation = b;
    }

    protected DatagramChannelImpl(SelectorProvider provider) throws IOException {
        super(provider);
        this.configureBlocking(true);
    }

    public int getNativeFD() {
        return this.socket.getPlainDatagramSocketImpl().getNativeFD();
    }

    public DatagramSocket socket() {
        return this.socket;
    }

    protected void implCloseSelectableChannel() throws IOException {
        this.socket.close();
    }

    protected void implConfigureBlocking(boolean blocking) throws IOException {
        this.socket.setSoTimeout(blocking ? 0 : 50);
    }

    public DatagramChannel connect(SocketAddress remote) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.socket.connect(remote);
        return this;
    }

    public DatagramChannel disconnect() throws IOException {
        this.socket.disconnect();
        return this;
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public int write(ByteBuffer src) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        return this.send(src, this.socket.getRemoteSocketAddress());
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (offset < 0 || offset > srcs.length || length < 0 || length > srcs.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        long result = 0L;
        for (int index = offset; index < offset + length; ++index) {
            result += (long)this.write(srcs[index]);
        }
        return result;
    }

    public int read(ByteBuffer dst) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        int remaining = dst.remaining();
        this.receive(dst);
        return remaining - dst.remaining();
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (offset < 0 || offset > dsts.length || length < 0 || length > dsts.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        long result = 0L;
        for (int index = offset; index < offset + length; ++index) {
            result += (long)this.read(dsts[index]);
        }
        return result;
    }

    public SocketAddress receive(ByteBuffer dst) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        try {
            SocketAddress socketAddress;
            int len = dst.capacity() - dst.position();
            DatagramPacket packet = dst.hasArray() ? new DatagramPacket(dst.array(), dst.arrayOffset() + dst.position(), len) : new DatagramPacket(new byte[len], len);
            boolean completed = false;
            try {
                this.begin();
                this.setInChannelOperation(true);
                this.socket.receive(packet);
                completed = true;
            }
            finally {
                socketAddress = null;
                this.end(completed);
                this.setInChannelOperation(false);
            }
            if (!dst.hasArray()) {
                dst.put(packet.getData(), packet.getOffset(), packet.getLength());
            } else {
                dst.position(dst.position() + packet.getLength());
            }
            socketAddress = packet.getSocketAddress();
            return socketAddress;
        }
        catch (SocketTimeoutException e) {
            SocketAddress socketAddress = null;
            return socketAddress;
        }
    }

    public int send(ByteBuffer src, SocketAddress target) throws IOException {
        byte[] buffer;
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        int offset = 0;
        int len = src.remaining();
        if (src.hasArray()) {
            buffer = src.array();
            offset = src.arrayOffset() + src.position();
        } else {
            buffer = new byte[len];
            src.get(buffer);
        }
        DatagramPacket packet = new DatagramPacket(buffer, offset, len, target);
        boolean completed = false;
        try {
            this.begin();
            this.setInChannelOperation(true);
            this.socket.send(packet);
            completed = true;
        }
        finally {
            Object var8_8 = null;
            this.end(completed);
            this.setInChannelOperation(false);
        }
        if (src.hasArray()) {
            src.position(src.position() + len);
        }
        int n = len;
        return n;
    }
}

