/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public abstract class JarURLConnection
extends URLConnection {
    private final URL jarFileURL;
    protected URLConnection jarFileURLConnection;
    private final String entryName;

    protected JarURLConnection(URL url) throws MalformedURLException {
        super(url);
        if (!url.getProtocol().equals("jar")) {
            throw new MalformedURLException(url + ": Not jar protocol.");
        }
        String spec = url.getFile();
        int bang = spec.indexOf("!/");
        if (bang == -1) {
            throw new MalformedURLException(url + ": No `!/' in spec.");
        }
        this.jarFileURL = new URL(spec.substring(0, bang));
        this.entryName = spec.length() == bang + 2 ? null : spec.substring(bang + 2);
    }

    public URL getJarFileURL() {
        return this.jarFileURL;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public JarEntry getJarEntry() throws IOException {
        JarFile jarfile = null;
        if (this.entryName == null) {
            return null;
        }
        if (!this.doInput) {
            throw new ProtocolException("Can't open JarEntry if doInput is false");
        }
        try {
            jarfile = this.getJarFile();
        }
        catch (IOException x) {
            // empty catch block
        }
        if (jarfile == null) {
            JarInputStream zis = new JarInputStream(this.jarFileURLConnection.getInputStream());
            ZipEntry ent = zis.getNextEntry();
            while (ent != null) {
                if (this.entryName.equals(ent.getName())) {
                    return new JarEntry(ent);
                }
                ent = zis.getNextEntry();
            }
        } else {
            return jarfile.getJarEntry(this.entryName);
        }
        return null;
    }

    public abstract JarFile getJarFile() throws IOException;

    public Certificate[] getCertificates() throws IOException {
        JarEntry entry = this.getJarEntry();
        if (entry != null) {
            return entry.getCertificates();
        }
        return null;
    }

    public Attributes getMainAttributes() throws IOException {
        Manifest manifest = this.getManifest();
        if (manifest != null) {
            return manifest.getMainAttributes();
        }
        return null;
    }

    public Attributes getAttributes() throws IOException {
        JarEntry entry = this.getJarEntry();
        if (entry != null) {
            return entry.getAttributes();
        }
        return null;
    }

    public Manifest getManifest() throws IOException {
        JarFile file = this.getJarFile();
        if (file != null) {
            return file.getManifest();
        }
        return null;
    }
}

