/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IdentityHashMap
extends AbstractMap
implements Map,
Serializable,
Cloneable {
    private static final int DEFAULT_CAPACITY = 21;
    static final Object tombstone = new Object();
    static final Object emptyslot = new Object();
    private static final long serialVersionUID = 8188218128353913216L;
    int size;
    transient Object[] table;
    transient int modCount;
    private transient Set entries;
    private transient int threshold;

    public IdentityHashMap() {
        this(21);
    }

    public IdentityHashMap(int max) {
        if (max < 0) {
            throw new IllegalArgumentException();
        }
        if (max < 2) {
            max = 2;
        }
        this.table = new Object[max << 1];
        Arrays.fill(this.table, emptyslot);
        this.threshold = (max >> 2) * 3;
    }

    public IdentityHashMap(Map m) {
        this(Math.max(m.size() << 1, 21));
        this.putAll(m);
    }

    public void clear() {
        if (this.size != 0) {
            ++this.modCount;
            Arrays.fill(this.table, emptyslot);
            this.size = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        try {
            void e;
            IdentityHashMap copy = (IdentityHashMap)super.clone();
            copy.table = (Object[])this.table.clone();
            copy.entries = null;
            return e;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean containsKey(Object key) {
        return key == this.table[this.hash(key)];
    }

    public boolean containsValue(Object value) {
        for (int i = this.table.length - 1; i > 0; i -= 2) {
            if (this.table[i] != value) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet(this){
                private /* synthetic */ IdentityHashMap this$0;
                {
                    this.this$0 = this$0;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return new IdentityIterator(this.this$0, 2);
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry m = (Map.Entry)o;
                    return m.getValue() == this.this$0.table[this.this$0.hash(m.getKey()) + 1];
                }

                public int hashCode() {
                    return this.this$0.hashCode();
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Object key = ((Map.Entry)o).getKey();
                    int h = this.this$0.hash(key);
                    if (this.this$0.table[h] == key) {
                        --this.this$0.size;
                        ++this.this$0.modCount;
                        this.this$0.table[h] = tombstone;
                        this.this$0.table[h + 1] = tombstone;
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.entries;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public Object get(Object key) {
        int h = this.hash(key);
        if (this.table[h] == key) {
            return this.table[h + 1];
        }
        return null;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = this.table.length - 2; i >= 0; i -= 2) {
            Object key = this.table[i];
            if (key == emptyslot || key == tombstone) continue;
            hash += System.identityHashCode(key) ^ System.identityHashCode(this.table[i + 1]);
        }
        return hash;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet(this){
                private /* synthetic */ IdentityHashMap this$0;
                {
                    this.this$0 = this$0;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return new IdentityIterator(this.this$0, 0);
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object o) {
                    return this.this$0.containsKey(o);
                }

                public int hashCode() {
                    int hash = 0;
                    for (int i = this.this$0.table.length - 2; i >= 0; i -= 2) {
                        Object key = this.this$0.table[i];
                        if (key == emptyslot || key == tombstone) continue;
                        hash += System.identityHashCode(key);
                    }
                    return hash;
                }

                public boolean remove(Object o) {
                    int h = this.this$0.hash(o);
                    if (this.this$0.table[h] == o) {
                        --this.this$0.size;
                        ++this.this$0.modCount;
                        this.this$0.table[h] = tombstone;
                        this.this$0.table[h + 1] = tombstone;
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.keys;
    }

    public Object put(Object key, Object value) {
        int h;
        if (this.size > this.threshold) {
            Object[] old = this.table;
            this.table = new Object[old.length << 3];
            Arrays.fill(this.table, emptyslot);
            this.size = 0;
            this.threshold = (this.table.length >>> 3) * 3;
            for (int i = old.length - 2; i >= 0; i -= 2) {
                Object oldkey = old[i];
                if (oldkey == tombstone || oldkey == emptyslot) continue;
                this.put(oldkey, old[i + 1]);
            }
        }
        if (this.table[h = this.hash(key)] == key) {
            Object r = this.table[h + 1];
            this.table[h + 1] = value;
            return r;
        }
        ++this.modCount;
        ++this.size;
        this.table[h] = key;
        this.table[h + 1] = value;
        return null;
    }

    public void putAll(Map m) {
        super.putAll(m);
    }

    public Object remove(Object key) {
        int h = this.hash(key);
        if (this.table[h] == key) {
            ++this.modCount;
            --this.size;
            Object r = this.table[h + 1];
            this.table[h] = tombstone;
            this.table[h + 1] = tombstone;
            return r;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(this){
                private /* synthetic */ IdentityHashMap this$0;
                {
                    this.this$0 = this$0;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return new IdentityIterator(this.this$0, 1);
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean remove(Object o) {
                    for (int i = this.this$0.table.length - 1; i > 0; i -= 2) {
                        if (this.this$0.table[i] != o) continue;
                        ++this.this$0.modCount;
                        this.this$0.table[i - 1] = tombstone;
                        this.this$0.table[i] = tombstone;
                        --this.this$0.size;
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.values;
    }

    int hash(Object key) {
        int h = Math.abs(System.identityHashCode(key) % (this.table.length >> 1)) << 1;
        int del = -1;
        int save = h;
        do {
            if (this.table[h] == key) {
                return h;
            }
            if (this.table[h] == emptyslot) break;
            if (this.table[h] == tombstone && del < 0) {
                del = h;
            }
            if ((h -= 2) >= 0) continue;
            h = this.table.length - 2;
        } while (h != save);
        if (del < 0) {
            return h;
        }
        return del;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int num = s.readInt();
        this.table = new Object[Math.max(num << 1, 21) << 1];
        while (--num >= 0) {
            this.put(s.readObject(), s.readObject());
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (int i = this.table.length - 2; i >= 0; i -= 2) {
            Object key = this.table[i];
            if (key == tombstone || key == emptyslot) continue;
            s.writeObject(key);
            s.writeObject(this.table[i + 1]);
        }
    }

    private final class IdentityEntry
    implements Map.Entry {
        private /* synthetic */ IdentityHashMap this$0;
        final int loc;
        final int knownMod;

        private /* synthetic */ void finit$() {
            this.knownMod = this.this$0.modCount;
        }

        IdentityEntry(IdentityHashMap this$0, int loc) {
            this.this$0 = this$0;
            this.finit$();
            this.loc = loc;
        }

        public boolean equals(Object o) {
            if (this.knownMod != this.this$0.modCount || this.this$0.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.this$0.table[this.loc] == e.getKey() && this.this$0.table[this.loc + 1] == e.getValue();
        }

        public Object getKey() {
            if (this.knownMod != this.this$0.modCount || this.this$0.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            return this.this$0.table[this.loc];
        }

        public Object getValue() {
            if (this.knownMod != this.this$0.modCount || this.this$0.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            return this.this$0.table[this.loc + 1];
        }

        public int hashCode() {
            if (this.knownMod != this.this$0.modCount || this.this$0.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            return System.identityHashCode(this.this$0.table[this.loc]) ^ System.identityHashCode(this.this$0.table[this.loc + 1]);
        }

        public Object setValue(Object value) {
            if (this.knownMod != this.this$0.modCount || this.this$0.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            Object r = this.this$0.table[this.loc + 1];
            this.this$0.table[this.loc + 1] = value;
            return r;
        }

        public final String toString() {
            if (this.knownMod != this.this$0.modCount || this.this$0.table[this.loc] == tombstone) {
                throw new ConcurrentModificationException();
            }
            return this.this$0.table[this.loc] + "=" + this.this$0.table[this.loc + 1];
        }
    }

    private final class IdentityIterator
    implements Iterator {
        private /* synthetic */ IdentityHashMap this$0;
        final int type;
        int knownMod;
        int count;
        int loc;

        private /* synthetic */ void finit$() {
            this.knownMod = this.this$0.modCount;
            this.count = this.this$0.size;
            this.loc = this.this$0.table.length;
        }

        IdentityIterator(IdentityHashMap this$0, int type) {
            this.this$0 = this$0;
            this.finit$();
            this.type = type;
        }

        public boolean hasNext() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.count > 0;
        }

        public Object next() {
            Object key;
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            do {
                this.loc -= 2;
            } while ((key = this.this$0.table[this.loc]) == emptyslot || key == tombstone);
            if (this.type == 0) {
                return key;
            }
            if (this.type == 1) {
                return this.this$0.table[this.loc + 1];
            }
            return new IdentityEntry(this.this$0, this.loc);
        }

        public void remove() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.loc == this.this$0.table.length || this.this$0.table[this.loc] == tombstone) {
                throw new IllegalStateException();
            }
            ++this.this$0.modCount;
            --this.this$0.size;
            this.this$0.table[this.loc] = tombstone;
            this.this$0.table[this.loc + 1] = tombstone;
            ++this.knownMod;
        }
    }
}

