#include <stdio.h>
#include <math.h>

double q1a = 6.456666666;
double q2a = 21.54333334;
double q1s = 2.398370280;
double q2s = 2.454913893;

double c1 = 0.5;

#define x_1(X1) (20*((X1)-0.55))
#define x_2(X2) (40*((X2)-0.375))

__inline double Q1P(double X1,double X2)
{
	double x1 = x_1(X1);
	double x2 = x_2(X2);
	return 5.18+3.44*x1+0.96*x2-1.33*x1*x2+3.83*x1*x1;
}

__inline double Q2R(double X1,double X2)
{
	double x1 = x_1(X1);
	double x2 = x_2(X2);
	return 22.5-3.72*x1+1.43*x2-2.87*x1*x1;
}

double f(double x,double y)
{
	double c2 = 1 - c1;
	return c2 * (Q2R(x,y)-q2a)/q2s - c1 * (Q1P(x,y)-q1a)/q1s;
}

#ifdef	DO_GRID
#define N 200
#else
#define N 3000
#endif

int main()
{
	int i, j;
	double x, xmin = 0.5, xmax = 0.6, xstep = (xmax - xmin) / N;
	double y, ymin = 0.35, ymax = 0.4, ystep = (ymax - ymin) / N;
	double z, zmin = 1e+99, zmax = -zmin;
#ifndef	DO_GRID
	double extrema[4]; 
#endif
	y = ymin;
	for(i = 0;i <= N;i++,y += ystep)
	{
		x = xmin;
		for(j = 0;j <= N;j++,x += xstep)
		{
			z = f(x,y);
			if(zmax < z)
			{
				zmax = z;
#ifndef	DO_GRID
				extrema[0] = x;
				extrema[1] = y;
#endif
			}
			if(zmin > z)
			{
				zmin = z;
#ifndef	DO_GRID
				extrema[2] = x;
				extrema[3] = y;
#endif
			}
		}
	}
#ifndef	DO_GRID
	puts("MAXIMUM:");
	printf("x = %g, y = %g, z = %g, ",extrema[0],extrema[1],zmax);
	printf("q1 = %g, q2 = %g\n",Q1P(extrema[0],extrema[1]), Q2R(extrema[0],extrema[1]));
	puts("MINIMUM:");
	printf("x = %g, y = %g, z = %g, ",extrema[2],extrema[3],zmin);
	printf("q1 = %g, q2 = %g\n",Q1P(extrema[2],extrema[3]), Q2R(extrema[2],extrema[3]));
#else
	printf("DSAA\n%u %u\n",N+1,N+1);
	printf("%g %g\n", xmin, xmax);
	printf("%g %g\n", ymin, ymax);
	printf("%g %g\n", zmin, zmax);
	y = ymin;
	for(i = 0;i <= N;i++,y += ystep)
	{
		x = xmin;
		for(j = 0;j <= N;j++,x += xstep)
		{
			printf("%g ",f(x,y));
		}
		puts("");
	}
#endif
	return 0;
}
